/*
 * Decompiled with CFR 0.152.
 */
package mgate.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class XMLNode {
    public XMLNode next;
    public XMLNode sub;
    private XMLNode lastPeer;
    public Vector properties;
    public String title;

    public XMLNode(String string) {
        this.title = string;
        this.next = null;
        this.sub = null;
        this.lastPeer = null;
        this.properties = new Vector();
    }

    public void addChild(XMLNode xMLNode) {
        if (this.sub == null) {
            this.sub = xMLNode;
        } else {
            this.sub.addPeer(xMLNode);
        }
    }

    public void addPeer(XMLNode xMLNode) {
        XMLNode xMLNode2 = this;
        if (this.lastPeer != null) {
            xMLNode2 = this.lastPeer;
        }
        while (xMLNode2.next != null) {
            xMLNode2 = xMLNode2.next;
        }
        xMLNode2.next = xMLNode;
        this.lastPeer = xMLNode;
    }

    public static boolean dump(File file, String string, XMLNode xMLNode, boolean bl) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            bufferedWriter.write(string);
            XMLNode.write(xMLNode, bufferedWriter, bl ? 0 : -1);
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean dumpCompressedGZip(File file, String string, XMLNode xMLNode) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(file))));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            bufferedWriter.write(string);
            XMLNode.write(xMLNode, bufferedWriter, -1);
            bufferedWriter.flush();
            bufferedWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addProperty(String string, String string2) {
        this.properties.add(new DualString(string, string2));
    }

    public String getProperty(String string) {
        for (int i = 0; i < this.properties.size(); ++i) {
            DualString dualString = (DualString)this.properties.get(i);
            if (!dualString.key.equals(string)) continue;
            return dualString.value;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public static void write(XMLNode xMLNode, BufferedWriter bufferedWriter, int n) throws Exception {
        XMLNode xMLNode2 = xMLNode;
        while (xMLNode2 != null) {
            int n2;
            if (n != -1) {
                for (n2 = 0; n2 < n; ++n2) {
                    bufferedWriter.write("\t");
                }
            }
            bufferedWriter.write("<");
            bufferedWriter.write(xMLNode2.title);
            for (n2 = 0; n2 < xMLNode2.properties.size(); ++n2) {
                DualString dualString = (DualString)xMLNode2.properties.elementAt(n2);
                bufferedWriter.write(" " + dualString.key + "=\"" + dualString.value + "\"");
            }
            if (xMLNode2.sub == null) {
                bufferedWriter.write("/");
            }
            bufferedWriter.write(">\n");
            if (xMLNode2.sub != null) {
                XMLNode cfr_ignored_0 = xMLNode2.sub;
                XMLNode.write(xMLNode2.sub, bufferedWriter, n == -1 ? -1 : n + 1);
                if (n != -1) {
                    for (n2 = 0; n2 < n; ++n2) {
                        bufferedWriter.write("\t");
                    }
                }
                bufferedWriter.write("</" + xMLNode2.title + ">\n");
            }
            xMLNode2 = xMLNode2.next;
        }
    }

    private class DualString {
        public String key;
        public String value;

        public DualString(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

